/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.facet.plain.histograms;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.apache.lucene.internal.hppc.LongIntHashMap;
import org.apache.lucene.sandbox.facet.plain.histograms.HistogramCollector;
import org.apache.lucene.search.CollectorManager;

public final class HistogramCollectorManager
implements CollectorManager<HistogramCollector, LongIntHashMap> {
    private static final int DEFAULT_MAX_BUCKETS = 1024;
    private final String field;
    private final long bucketWidth;
    private final int maxBuckets;

    public HistogramCollectorManager(String field, long bucketWidth) {
        this(field, bucketWidth, 1024);
    }

    public HistogramCollectorManager(String field, long bucketWidth, int maxBuckets) {
        this.field = Objects.requireNonNull(field);
        if (bucketWidth < 2L) {
            throw new IllegalArgumentException("bucketWidth must be at least 2, got: " + bucketWidth);
        }
        this.bucketWidth = bucketWidth;
        if (maxBuckets < 1) {
            throw new IllegalArgumentException("maxBuckets must be at least 1, got: " + maxBuckets);
        }
        this.maxBuckets = maxBuckets;
    }

    public HistogramCollector newCollector() throws IOException {
        return new HistogramCollector(this.field, this.bucketWidth, this.maxBuckets);
    }

    public LongIntHashMap reduce(Collection<HistogramCollector> collectors) throws IOException {
        LongIntHashMap reduced = new LongIntHashMap();
        for (HistogramCollector collector : collectors) {
            for (LongIntHashMap.LongIntCursor cursor : collector.getCounts()) {
                reduced.addTo(cursor.key, cursor.value);
                HistogramCollector.checkMaxBuckets(reduced.size(), this.maxBuckets);
            }
        }
        return reduced;
    }
}

