/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jooq.Commit;
import org.jooq.Commits;
import org.jooq.Configuration;
import org.jooq.ContentType;
import org.jooq.ContextTransactionalRunnable;
import org.jooq.File;
import org.jooq.Files;
import org.jooq.HistoryVersion;
import org.jooq.Meta;
import org.jooq.Migration;
import org.jooq.MigrationListener;
import org.jooq.Queries;
import org.jooq.Query;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.Tag;
import org.jooq.Version;
import org.jooq.conf.MigrationSchema;
import org.jooq.exception.DataAccessException;
import org.jooq.exception.DataMigrationException;
import org.jooq.exception.DataMigrationVerificationException;
import org.jooq.impl.AbstractScope;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultMigrationContext;
import org.jooq.impl.History;
import org.jooq.impl.HistoryImpl;
import org.jooq.impl.HistoryRecord;
import org.jooq.impl.HistoryResolution;
import org.jooq.impl.HistoryStatus;
import org.jooq.impl.MigrationListeners;
import org.jooq.impl.SchemaImpl;
import org.jooq.impl.ThreadLocalTransactionProvider;
import org.jooq.impl.Tools;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StopWatch;
import org.jooq.tools.StringUtils;
import org.jooq.tools.json.JSONArray;

final class MigrationImpl
extends AbstractScope
implements Migration {
    static final JooqLogger log = JooqLogger.getLogger(MigrationImpl.class);
    final HistoryImpl history;
    final Commit to;
    Commit from;
    Queries queries;
    Commits commits;

    MigrationImpl(Configuration configuration, Commit to) {
        super(HistoryImpl.initCtx(configuration.derive(new ThreadLocalTransactionProvider(configuration.systemConnectionProvider())), configuration.settings().getMigrationDefaultSchema()));
        this.to = to;
        this.history = new HistoryImpl(this.configuration());
    }

    static final Schema schema(MigrationSchema schema) {
        return new SchemaImpl(DSL.name(schema.getCatalog(), schema.getSchema()));
    }

    @Override
    public final Commit from() {
        return this.from0(false);
    }

    final Commit from0(boolean baseline) {
        if (this.from == null) {
            this.from = this.currentCommit(baseline);
        }
        return this.from;
    }

    @Override
    public final Commit fromSnapshot() {
        if (this.configuration().commercial()) {
            // empty if block
        }
        return null;
    }

    @Override
    public final Commit to() {
        return this.to;
    }

    @Override
    public final Queries queries() {
        if (this.queries == null) {
            Files files = this.from().migrateTo(this.to());
            this.queries = files.from().migrateTo(files.to());
        }
        return this.queries;
    }

    private final Commits commits() {
        if (this.commits == null) {
            this.commits = this.configuration().commitProvider().provide();
        }
        return this.commits;
    }

    @Override
    public final Queries untracked() {
        return this.untracked(false, this.history.schemas()).apply();
    }

    @Override
    public final void verify() {
        this.verify0(this.migrationContext(false));
    }

    @Override
    public void baseline() {
        if (this.history.existsHistory()) {
            throw new DataMigrationVerificationException("Cannot create a baseline when a history already exists");
        }
        this.execute0(true);
    }

    private final void verify0(DefaultMigrationContext ctx) {
        HistoryRecord currentRecord = this.history.currentHistoryRecord(false);
        if (currentRecord != null) {
            switch (currentRecord.getStatus()) {
                case FAILURE: {
                    throw new DataMigrationVerificationException("Previous migration attempt from " + currentRecord.getMigratedFrom() + " to " + currentRecord.getMigratedTo() + " has failed. Please resolve before migrating.");
                }
                case STARTING: 
                case REVERTING: 
                case MIGRATING: {
                    throw new DataMigrationVerificationException("Ongoing migration from " + currentRecord.getMigratedFrom() + " to " + currentRecord.getMigratedTo() + ". Please wait until it has finished.");
                }
            }
            Commit currentCommit = this.commits().get(currentRecord.getMigratedTo());
            if (currentCommit == null) {
                throw new DataMigrationVerificationException("Version currently installed is not available from CommitProvider: " + currentRecord.getMigratedTo());
            }
        }
        this.validateCommitProvider(ctx, this.from());
        this.validateCommitProvider(ctx, this.to());
        this.revertUntracked(ctx, null, currentRecord);
        if (!this.to().valid() && !Boolean.TRUE.equals(ctx.settings().isMigrationAllowInvalidCommits())) {
            throw new DataMigrationVerificationException("Commit is not a valid commit to migrate to: {commit}\nInvalid commits include:\n- Uncommitted or untracked changes in the GitCommitProvider\n- Commits leading to inconsistent migration states due to editing of commit paths\n".replace("{commit}", this.to().id()));
        }
    }

    private final void validateCommitProvider(DefaultMigrationContext ctx, Commit commit) {
        if (this.commits().get(commit.id()) == null) {
            throw new DataMigrationVerificationException("Commit is not available from CommitProvider: " + commit.id());
        }
        for (Schema schema : this.history.lookup(commit.meta().getSchemas())) {
            if (StringUtils.isEmpty(schema.getName()) || ctx.migratedSchemas().contains(schema)) continue;
            throw new DataMigrationVerificationException("Schema is referenced from commit, but not configured for migration: {schema}.\nThe commit referencing the schema: {commit}.\n\nAll schemas that are referenced from commits in a migration must be configured for\ninclusion in the migration.\n".replace("{schema}", schema.toString()).replace("{commit}", commit.toString()));
        }
    }

    private final Untracked untracked(boolean baseline, Set<Schema> includedSchemas) {
        Schema d;
        if (this.scriptsOnly()) {
            return new Untracked(this.configuration(), null, null);
        }
        MigrationSchema hs = this.settings().getMigrationHistorySchema();
        MigrationSchema ds = this.settings().getMigrationDefaultSchema();
        HashSet<Table> historyTables = new HashSet<Table>();
        if (hs != null || ds != null) {
            historyTables.add(DSL.table(MigrationImpl.schema(hs != null ? hs : ds).getQualifiedName().append(History.HISTORY.getUnqualifiedName())));
        } else {
            historyTables.addAll(Tools.map(includedSchemas, s -> DSL.table(s.getQualifiedName().append(History.HISTORY.getUnqualifiedName()))));
        }
        Commit currentCommit = this.currentCommit(baseline);
        Meta currentMeta = currentCommit.meta();
        Meta existingMeta = this.dsl().meta().filterSchemas(includedSchemas::contains).filterTables(t -> !historyTables.contains(t));
        HashSet<Schema> expectedSchemas = new HashSet<Schema>();
        expectedSchemas.addAll(this.history.lookup(this.from().meta().getSchemas()));
        expectedSchemas.addAll(this.history.lookup(this.to().meta().getSchemas()));
        expectedSchemas.retainAll(includedSchemas);
        if (ds != null && expectedSchemas.contains(d = SchemaImpl.DEFAULT_SCHEMA.get()) && includedSchemas.contains(d)) {
            expectedSchemas.add(MigrationImpl.schema(ds));
        }
        for (Schema schema : existingMeta.getSchemas()) {
            if (!includedSchemas.contains(schema)) continue;
            if (!expectedSchemas.contains(schema)) {
                existingMeta = existingMeta.apply(DSL.dropSchemaIfExists(schema).cascade());
                continue;
            }
            currentMeta = currentMeta.apply(DSL.createSchemaIfNotExists(schema));
        }
        return new Untracked(this.configuration(), currentMeta, existingMeta);
    }

    private final boolean scriptsOnly() {
        for (Commit commit : this.commits()) {
            for (File file : commit.delta()) {
                if (file.type() == ContentType.SCRIPT) continue;
                return false;
            }
        }
        return true;
    }

    private final void revertUntracked(DefaultMigrationContext ctx, MigrationListener listener, HistoryRecord currentRecord) {
        if (ctx.revertUntrackedQueries.queries().length > 0) {
            if (!Boolean.TRUE.equals(this.dsl().settings().isMigrationRevertUntracked())) {
                if (currentRecord == null) {
                    throw new DataMigrationVerificationException("Non-empty difference between actual schema and migration from schema:\n{queries}\n\nPossible remedies:\n- Use Settings.migrationAutoBaseline or the baseline command to automatically set a baseline.\n".replace("{queries}", String.valueOf(ctx.revertUntrackedQueries)));
                }
                throw new DataMigrationVerificationException("Non-empty difference between actual schema and migration from schema:\n{queries}.\n\nThis can happen for at least 3 reasons:\n1) The migration specification of a version that has already been installed has been modified.\n2) The database schemas contain untracked objects.\n3) There's a false positive reported by the database / org.jooq.Meta. Please consider reporting\n   it here: https://jooq.org/bug\n\nPossible remedies if 1):\n- Revert changes to the migration specification and move those changes to a new version.\n\nPossible remedies if 2):\n- Use Settings.migrationRevertUntracked to automatically drop unknown objects (at your own risk!)\n- Manually drop or move unknown objects outside of managed schemas.\n- Update migration scripts to track missing objects (including adding them automatically).\n".replace("{queries}", String.valueOf(ctx.revertUntrackedQueries)));
            }
            if (listener != null) {
                this.execute(ctx, listener, ctx.revertUntrackedQueries);
            }
        }
    }

    final DefaultMigrationContext migrationContext(boolean baseline) {
        Set<Schema> schemas = this.history.schemas();
        return new DefaultMigrationContext(this.configuration(), schemas, this.from0(baseline), this.to(), this.queries(), this.untracked(baseline, schemas).revert());
    }

    @Override
    public final void execute() {
        this.execute0(false);
    }

    void execute0(boolean baseline) {
        this.run(() -> {
            DefaultMigrationContext ctx = this.migrationContext(baseline);
            MigrationListeners listener = new MigrationListeners(this.configuration);
            if (!Boolean.FALSE.equals(this.dsl().settings().isMigrationAutoVerification())) {
                this.verify0(ctx);
            }
            this.init();
            try {
                listener.migrationStart(ctx);
                if (this.from().equals(this.to())) {
                    if (log.isInfoEnabled()) {
                        log.info("Version " + this.to().id() + " is already installed as the current version.");
                    }
                    return;
                }
                if (log.isInfoEnabled()) {
                    Commit snapshot = this.fromSnapshot();
                    log.info("Version " + this.from().id() + " is being migrated to " + this.to().id() + (String)(snapshot != null ? " (from snapshot: " + snapshot.id() + ")" : ""));
                }
                StopWatch watch = new StopWatch();
                if (log.isDebugEnabled()) {
                    for (Query query : this.queries()) {
                        log.debug(this.dsl().renderInlined(query));
                    }
                }
                HistoryRecord record = this.createRecord(HistoryStatus.STARTING);
                try {
                    this.log(watch, record, HistoryStatus.REVERTING);
                    this.revertUntracked(ctx, listener, record);
                    this.log(watch, record, HistoryStatus.MIGRATING);
                    this.execute(ctx, listener, this.queries());
                    this.log(watch, record, HistoryStatus.SUCCESS);
                }
                catch (Exception e) {
                    StringWriter s = new StringWriter();
                    e.printStackTrace(new PrintWriter(s));
                    if (log.isErrorEnabled()) {
                        log.error("Version " + this.from().id() + " migration to " + this.to().id() + " failed: " + e.getMessage());
                    }
                    this.log(watch, record, HistoryStatus.FAILURE, HistoryResolution.OPEN, s.toString());
                    throw new DataMigrationRedoLogException(record, e);
                }
            }
            finally {
                listener.migrationEnd(ctx);
            }
        });
    }

    private final HistoryRecord createRecord(HistoryStatus status) {
        String hostName;
        HistoryRecord record = this.history.historyCtx.newRecord(History.HISTORY);
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostName = "unknown";
        }
        record.setJooqVersion("3.20.5").setMigratedAt(new Timestamp(this.dsl().configuration().clock().instant().toEpochMilli())).setMigratedFrom(this.from().id()).setMigratedTo(this.to().id()).setMigratedToMessage(this.to().message()).setMigratedToTags(new JSONArray(Tools.map(this.to().tags(), Tag::id)).toString()).setMigrationTime(0L).setClientUserName(System.getProperty("user.name")).setClientHostName(hostName).setSql(this.queries().toString()).setSqlCount(this.queries().queries().length).setStatus(status).insert();
        return record;
    }

    private final void log(StopWatch watch, HistoryRecord record, HistoryStatus status) {
        this.log(watch, record, status, null, null);
    }

    private final void log(StopWatch watch, HistoryRecord record, HistoryStatus status, HistoryResolution resolution, String message) {
        record.setMigrationTime(watch.split() / 1000000L).setStatus(status).setStatusMessage(message).setResolution(resolution).update();
    }

    private final void execute(DefaultMigrationContext ctx, MigrationListener listener, Queries q) {
        listener.queriesStart(ctx);
        for (Query query : q.queries()) {
            ctx.query(query);
            listener.queryStart(ctx);
            query.execute();
            listener.queryEnd(ctx);
            ctx.query(null);
        }
        listener.queriesEnd(ctx);
    }

    final void init() {
        this.history.init();
        DefaultMigrationContext ctx = this.migrationContext(false);
        if (Boolean.TRUE.equals(ctx.settings().isMigrationSchemataCreateSchemaIfNotExists())) {
            for (Schema schema : ctx.migratedSchemas()) {
                this.dsl().createSchemaIfNotExists(schema).execute();
            }
        }
    }

    final Commit currentCommit(boolean baseline) {
        HistoryRecord currentRecord = this.history.currentHistoryRecord(true);
        if (currentRecord == null) {
            Commit result;
            Commit commit = result = baseline || Boolean.TRUE.equals(this.settings().isMigrationAutoBaseline()) ? this.to() : (Commit)this.to().root();
            if (result == null) {
                throw new DataMigrationVerificationException("CommitProvider did not provide a root version for " + this.to().id());
            }
            return result;
        }
        Commit result = this.commits().get(currentRecord.getMigratedTo());
        if (result == null) {
            throw new DataMigrationVerificationException("CommitProvider did not provide a version for " + currentRecord.getMigratedTo());
        }
        return result;
    }

    private final void run(ContextTransactionalRunnable runnable) {
        try {
            this.dsl().transaction(runnable);
        }
        catch (DataMigrationRedoLogException e) {
            try {
                HistoryRecord record = this.history.currentHistoryRecord(false);
                if (record == null || !StringUtils.equals(e.record.getId(), record.getId())) {
                    e.record.touched(true);
                    e.record.insert();
                }
            }
            catch (DataAccessException s) {
                e.addSuppressed(s);
            }
            Throwable throwable = e.getCause();
            if (throwable instanceof DataMigrationException) {
                DataMigrationException r = (DataMigrationException)throwable;
                throw r;
            }
            throw new DataMigrationException("Exception during migration", e);
        }
        catch (DataMigrationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataMigrationException("Exception during migration", e);
        }
    }

    @Override
    public final void logHistory() {
        List versions = Tools.collect(() -> this.history.iterator());
        if (versions.isEmpty()) {
            log.info("No migration history available yet");
        } else {
            log.info("Migration history");
            for (HistoryVersion version : versions.subList(Math.max(0, versions.size() - 5), versions.size())) {
                MigrationImpl.log(version);
            }
        }
    }

    static final void log(HistoryVersion version) {
        log.info("  " + MigrationImpl.string(version.migratedAt()) + " - Version: " + MigrationImpl.string(version.version()));
        if (version.version().parents().size() > 1) {
            log.info("  Merged parents: ");
            for (Version p : version.version().parents()) {
                log.info("  - " + MigrationImpl.string(p));
            }
        }
    }

    private static final String string(Instant instant) {
        if (instant == null) {
            return "0000-00-00T00:00:00.000Z";
        }
        return StringUtils.rightPad(instant.toString(), 24);
    }

    private static final String string(Version version) {
        return version.id() + (String)(!StringUtils.isEmpty(version.message()) ? " (" + version.message() + ")" : "");
    }

    @Override
    public final void logPending() {
        Query[] q = this.queries().queries();
        log.info("Pending queries from " + this.from().id() + " to " + this.to().id() + ": " + (q.length == 0 ? "none" : ""));
        MigrationImpl.log(q);
    }

    @Override
    public final void logUntracked() {
        Query[] q = this.untracked().queries();
        log.info("Untracked changes at " + this.from().id() + ": " + (q.length == 0 ? "none" : ""));
        MigrationImpl.log(q);
    }

    static final void log(Query[] queries) {
        for (int i = 0; i < queries.length; ++i) {
            log.info(queries[i]);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("-- Migration\n--   From: ").append(this.from().id()).append("\n").append("--   To  : ").append(this.to().id()).append("\n").append(this.queries());
        return sb.toString();
    }

    record Untracked(Configuration configuration, Meta current, Meta existing) {
        Queries revert() {
            if (this.existing() == null) {
                return this.configuration().dsl().queries(new Query[0]);
            }
            return this.existing().migrateTo(this.current());
        }

        Queries apply() {
            if (this.current() == null) {
                return this.configuration().dsl().queries(new Query[0]);
            }
            return this.current().migrateTo(this.existing());
        }
    }

    static final class DataMigrationRedoLogException
    extends DataMigrationException {
        final HistoryRecord record;

        public DataMigrationRedoLogException(HistoryRecord record, Exception cause) {
            super("Redo log", cause);
            this.record = record;
        }
    }
}

