/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieve.postgres;

import jakarta.inject.Inject;
import java.util.Optional;
import org.apache.james.backends.postgres.quota.PostgresQuotaCurrentValueDAO;
import org.apache.james.backends.postgres.quota.PostgresQuotaLimitDAO;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaComponent;
import org.apache.james.core.quota.QuotaCurrentValue;
import org.apache.james.core.quota.QuotaLimit;
import org.apache.james.core.quota.QuotaScope;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaType;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class PostgresSieveQuotaDAO {
    public static final QuotaComponent QUOTA_COMPONENT = QuotaComponent.of((String)"SIEVE");
    public static final String GLOBAL = "GLOBAL";
    private final PostgresQuotaCurrentValueDAO currentValueDao;
    private final PostgresQuotaLimitDAO limitDao;

    @Inject
    public PostgresSieveQuotaDAO(PostgresQuotaCurrentValueDAO currentValueDao, PostgresQuotaLimitDAO limitDao) {
        this.currentValueDao = currentValueDao;
        this.limitDao = limitDao;
    }

    public Mono<Long> spaceUsedBy(Username username) {
        QuotaCurrentValue.Key quotaKey = this.asQuotaKey(username);
        return this.currentValueDao.getQuotaCurrentValue(quotaKey).map(QuotaCurrentValue::getCurrentValue).switchIfEmpty(Mono.just((Object)0L));
    }

    private QuotaCurrentValue.Key asQuotaKey(Username username) {
        return QuotaCurrentValue.Key.of((QuotaComponent)QUOTA_COMPONENT, (String)username.asString(), (QuotaType)QuotaType.SIZE);
    }

    public Mono<Void> updateSpaceUsed(Username username, long spaceUsed) {
        QuotaCurrentValue.Key quotaKey = this.asQuotaKey(username);
        return this.currentValueDao.increase(quotaKey, spaceUsed);
    }

    public Mono<Optional<QuotaSizeLimit>> getGlobalQuota() {
        return this.limitDao.getQuotaLimit(QuotaLimit.QuotaLimitKey.of((QuotaComponent)QUOTA_COMPONENT, (QuotaScope)QuotaScope.GLOBAL, (String)GLOBAL, (QuotaType)QuotaType.SIZE)).map(v -> v.getQuotaLimit().map(QuotaSizeLimit::size)).switchIfEmpty(Mono.just(Optional.empty()));
    }

    public Mono<Void> setGlobalQuota(QuotaSizeLimit quota) {
        return this.limitDao.setQuotaLimit(QuotaLimit.builder().quotaComponent(QUOTA_COMPONENT).quotaScope(QuotaScope.GLOBAL).quotaType(QuotaType.SIZE).identifier(GLOBAL).quotaLimit(Long.valueOf(quota.asLong())).build());
    }

    public Mono<Void> removeGlobalQuota() {
        return this.limitDao.deleteQuotaLimit(QuotaLimit.QuotaLimitKey.of((QuotaComponent)QUOTA_COMPONENT, (QuotaScope)QuotaScope.GLOBAL, (String)GLOBAL, (QuotaType)QuotaType.SIZE));
    }

    public Mono<Optional<QuotaSizeLimit>> getQuota(Username username) {
        return this.limitDao.getQuotaLimits(QUOTA_COMPONENT, QuotaScope.USER, username.asString()).map(v -> v.getQuotaLimit().map(QuotaSizeLimit::size)).switchIfEmpty((Publisher)Mono.just(Optional.empty())).single();
    }

    public Mono<Void> setQuota(Username username, QuotaSizeLimit quota) {
        return this.limitDao.setQuotaLimit(QuotaLimit.builder().quotaComponent(QUOTA_COMPONENT).quotaScope(QuotaScope.USER).quotaType(QuotaType.SIZE).identifier(username.asString()).quotaLimit(Long.valueOf(quota.asLong())).build());
    }

    public Mono<Void> removeQuota(Username username) {
        return this.limitDao.deleteQuotaLimit(QuotaLimit.QuotaLimitKey.of((QuotaComponent)QUOTA_COMPONENT, (QuotaScope)QuotaScope.USER, (String)username.asString(), (QuotaType)QuotaType.SIZE));
    }

    public Mono<Void> resetSpaceUsed(Username username, long spaceUsed) {
        return this.spaceUsedBy(username).flatMap(currentSpace -> this.currentValueDao.increase(this.asQuotaKey(username), spaceUsed - currentSpace));
    }
}

