/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.BinaryColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.BytesUtils;

public class Replace2ColumnTransformer
extends BinaryColumnTransformer {
    public Replace2ColumnTransformer(Type returnType, ColumnTransformer leftTransformer, ColumnTransformer rightTransformer) {
        super(returnType, leftTransformer, rightTransformer);
    }

    @Override
    protected void checkType() {
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount) {
        Type leftType = this.leftTransformer.getType();
        Type rightType = this.rightTransformer.getType();
        int n = leftColumn.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (!leftColumn.isNull(i) && !rightColumn.isNull(i)) {
                this.returnType.writeBinary(builder, BytesUtils.valueOf((String)leftType.getBinary(leftColumn, i).getStringValue(TSFileConfig.STRING_CHARSET).replace(rightType.getBinary(rightColumn, i).getStringValue(TSFileConfig.STRING_CHARSET), "")));
                continue;
            }
            builder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount, boolean[] selection) {
        Type leftType = this.leftTransformer.getType();
        Type rightType = this.rightTransformer.getType();
        int n = leftColumn.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (selection[i] && !leftColumn.isNull(i) && !rightColumn.isNull(i)) {
                this.returnType.writeBinary(builder, BytesUtils.valueOf((String)leftType.getBinary(leftColumn, i).getStringValue(TSFileConfig.STRING_CHARSET).replace(rightType.getBinary(rightColumn, i).getStringValue(TSFileConfig.STRING_CHARSET), "")));
                continue;
            }
            builder.appendNull();
        }
    }
}

