/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.schema;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.isession.ITableSession;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.isession.pool.ITableSessionPool;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.pool.TableSessionPoolBuilder;
import org.apache.iotdb.tool.data.ImportDataScanTool;
import org.apache.iotdb.tool.schema.AbstractImportSchema;
import org.apache.tsfile.read.common.RowRecord;

public class ImportSchemaTable
extends AbstractImportSchema {
    private static final IoTPrinter ioTPrinter = new IoTPrinter(System.out);
    private static ITableSessionPool sessionPool;

    @Override
    public void init() throws InterruptedException {
        sessionPool = new TableSessionPoolBuilder().nodeUrls(Collections.singletonList(host + ":" + port)).user(username).password(password).maxSize(threadNum + 1).enableCompression(false).enableRedirection(false).enableAutoFetch(false).database(database).build();
        File file = new File(targetPath);
        if (!file.isFile() && !file.isDirectory()) {
            ioTPrinter.println(String.format("Source file or directory %s does not exist", targetPath));
            System.exit(1);
        }
        SessionDataSet sessionDataSet = null;
        try (ITableSession session = sessionPool.getSession();){
            ArrayList<String> databases = new ArrayList<String>();
            sessionDataSet = session.executeQueryStatement("show databases");
            while (sessionDataSet.hasNext()) {
                RowRecord rowRecord = sessionDataSet.next();
                databases.add(rowRecord.getField(0).getStringValue());
            }
            if (!databases.contains(database)) {
                ioTPrinter.println(String.format("The target database %s does not exist", database));
                System.exit(1);
            }
        }
        catch (StatementExecutionException e) {
            ioTPrinter.println("Meet error when insert csv because " + e.getMessage());
            System.exit(1);
        }
        catch (IoTDBConnectionException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ObjectUtils.isNotEmpty((Object)sessionDataSet)) {
                try {
                    sessionDataSet.close();
                }
                catch (Exception e) {}
            }
        }
        ImportDataScanTool.setSourceFullPath(targetPath);
        ImportDataScanTool.traverseAndCollectFiles();
    }

    @Override
    protected Runnable getAsyncImportRunnable() {
        return new ImportSchemaTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void importSchemaFromSqlFile(File file) {
        ArrayList<List<String>> failedRecords = new ArrayList<List<String>>();
        String failedFilePath = failedFileDirectory == null ? file.getAbsolutePath() + ".failed" : failedFileDirectory + file.getName() + ".failed";
        try (BufferedReader br = new BufferedReader(new FileReader(file.getAbsolutePath()));){
            String string;
            Object sqlBuilder = new StringBuilder();
            block39: while ((string = br.readLine()) != null) {
                if (!string.contains(";")) {
                    ((StringBuilder)sqlBuilder).append(string);
                    continue;
                }
                String[] sqls = string.split(";");
                boolean addBuilder = false;
                if (sqls.length > 0) {
                    if (!string.endsWith(";")) {
                        addBuilder = true;
                    }
                    for (int i = 0; i < sqls.length; ++i) {
                        ((StringBuilder)sqlBuilder).append(sqls[i]);
                        if (i == sqls.length - 1 && addBuilder) continue block39;
                        String builderString = ((StringBuilder)sqlBuilder).toString();
                        try (ITableSession session = sessionPool.getSession();){
                            session.executeNonQueryStatement(builderString);
                            sqlBuilder = new StringBuilder();
                            continue;
                        }
                        catch (IoTDBConnectionException | StatementExecutionException e) {
                            failedRecords.add(Collections.singletonList(builderString));
                            sqlBuilder = new StringBuilder();
                        }
                    }
                    continue;
                }
                String builderString = ((StringBuilder)sqlBuilder).toString();
                try {
                    ITableSession session = sessionPool.getSession();
                    try {
                        session.executeNonQueryStatement(builderString);
                        sqlBuilder = new StringBuilder();
                    }
                    finally {
                        if (session == null) continue;
                        session.close();
                    }
                }
                catch (IoTDBConnectionException | StatementExecutionException e) {
                    failedRecords.add(Collections.singletonList(builderString));
                    sqlBuilder = new StringBuilder();
                }
            }
            String builderString = ((StringBuilder)sqlBuilder).toString();
            if (StringUtils.isNotBlank((CharSequence)builderString)) {
                try (ITableSession session = sessionPool.getSession();){
                    session.executeNonQueryStatement(((StringBuilder)sqlBuilder).toString());
                }
                catch (IoTDBConnectionException | StatementExecutionException e) {
                    failedRecords.add(Collections.singletonList(builderString));
                    sqlBuilder = new StringBuilder();
                }
            }
            this.processSuccessFile();
        }
        catch (IOException e) {
            ioTPrinter.println("SQL file read exception because: " + e.getMessage());
        }
        if (!failedRecords.isEmpty()) {
            FileWriter writer = null;
            try {
                writer = new FileWriter(failedFilePath);
                for (List list : failedRecords) {
                    writer.write(list.get(0).toString() + ";\n");
                }
            }
            catch (IOException e) {
                ioTPrinter.println("Cannot dump fail result because: " + e.getMessage());
            }
            finally {
                if (ObjectUtils.isNotEmpty((Object)writer)) {
                    try {
                        writer.flush();
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    protected void importSchemaFromCsvFile(File file) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

