/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.disk;

import java.io.File;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.exception.load.LoadFileException;
import org.apache.iotdb.db.storageengine.load.disk.ILoadDiskSelector;
import org.apache.iotdb.db.storageengine.rescon.disk.TierManager;
import org.apache.tsfile.fileSystem.FSFactoryProducer;
import org.apache.tsfile.fileSystem.fsFactory.FSFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InheritSystemMultiDisksStrategySelector
implements ILoadDiskSelector {
    protected final FSFactory fsFactory = FSFactoryProducer.getFSFactory();
    private static final Logger logger = LoggerFactory.getLogger(InheritSystemMultiDisksStrategySelector.class);

    @Override
    public File getTargetFile(File fileToLoad, String databaseName, String dataRegionId, long filePartitionId, String tsfileName, int tierLevel) throws DiskSpaceInsufficientException, LoadFileException {
        try {
            return TierManager.getInstance().getFolderManager(tierLevel, false).getNextWithRetry(folder -> this.fsFactory.getFile(folder, databaseName + File.separatorChar + dataRegionId + File.separatorChar + filePartitionId + File.separator + tsfileName));
        }
        catch (DiskSpaceInsufficientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LoadFileException(String.format("Storage allocation failed for %s/%s/%s (tier %d)", databaseName, dataRegionId, filePartitionId, tierLevel), e);
        }
    }
}

