/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TNodeLocations;
import org.apache.iotdb.common.rpc.thrift.TTestConnectionResult;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.confignode.client.async.CnToDnAsyncRequestType;
import org.apache.iotdb.confignode.client.async.CnToDnInternalServiceAsyncRequestManager;
import org.apache.iotdb.confignode.client.async.handlers.DataNodeAsyncRequestContext;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.load.cache.AbstractHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.IFailureDetector;
import org.apache.iotdb.confignode.manager.load.cache.detector.FixedDetector;
import org.apache.iotdb.confignode.manager.load.cache.detector.PhiAccrualDetector;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeStatistics;
import org.apache.iotdb.confignode.manager.load.subscriber.IClusterStatusSubscriber;
import org.apache.iotdb.confignode.manager.load.subscriber.NodeStatisticsChangeEvent;
import org.apache.ratis.util.AwaitForSignal;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyService
implements Runnable,
IClusterStatusSubscriber {
    private static final Logger LOGGER = LoggerFactory.getLogger(TopologyService.class);
    private static final long PROBING_INTERVAL_MS = 5000L;
    private static final long PROBING_TIMEOUT_MS = 5000L;
    private static final int SAMPLING_WINDOW_SIZE = 100;
    private final ExecutorService topologyThread = IoTDBThreadPoolFactory.newSingleThreadExecutor((String)ThreadName.CONFIG_NODE_TOPOLOGY_SERVICE.getName());
    private Future<?> future = null;
    private final Consumer<Map<Integer, Set<Integer>>> topologyChangeListener;
    private final AwaitForSignal awaitForSignal;
    private final IManager configManager;
    private final AtomicBoolean shouldRun;
    private final Map<Pair<Integer, Integer>, List<AbstractHeartbeatSample>> heartbeats;
    private final List<Integer> startingDataNodes = new CopyOnWriteArrayList<Integer>();
    private final IFailureDetector failureDetector;
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();

    public TopologyService(IManager configManager, Consumer<Map<Integer, Set<Integer>>> topologyChangeListener) {
        this.configManager = configManager;
        this.topologyChangeListener = topologyChangeListener;
        this.heartbeats = new ConcurrentHashMap<Pair<Integer, Integer>, List<AbstractHeartbeatSample>>();
        this.shouldRun = new AtomicBoolean(false);
        this.awaitForSignal = new AwaitForSignal((Object)this.getClass().getSimpleName());
        switch (CONF.getFailureDetector()) {
            case "phi_accrual": {
                this.failureDetector = new PhiAccrualDetector(CONF.getFailureDetectorPhiThreshold(), CONF.getFailureDetectorPhiAcceptablePauseInMs() * 1000000L, CONF.getHeartbeatIntervalInMs() * 200000L, 60, new FixedDetector(CONF.getFailureDetectorFixedThresholdInMs() * 1000000L));
                break;
            }
            default: {
                this.failureDetector = new FixedDetector(CONF.getFailureDetectorFixedThresholdInMs() * 1000000L);
            }
        }
    }

    public synchronized void startTopologyService() {
        if (this.future == null) {
            this.future = this.topologyThread.submit(this);
        }
        this.shouldRun.set(true);
        LOGGER.info("Topology Probing has started successfully");
    }

    public synchronized void stopTopologyService() {
        this.shouldRun.set(false);
        this.future.cancel(true);
        this.future = null;
        this.heartbeats.clear();
        LOGGER.info("Topology Probing has stopped successfully");
    }

    private boolean mayWait() {
        try {
            this.awaitForSignal.await(5000L, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public void run() {
        while (this.shouldRun.get() && this.mayWait()) {
            this.topologyProbing();
        }
    }

    private synchronized void topologyProbing() {
        ArrayList<TDataNodeLocation> dataNodeLocations = new ArrayList<TDataNodeLocation>();
        HashSet<Integer> dataNodeIds = new HashSet<Integer>();
        for (TDataNodeConfiguration dataNodeConf : this.configManager.getNodeManager().getRegisteredDataNodes()) {
            TDataNodeLocation location2 = dataNodeConf.getLocation();
            if (this.startingDataNodes.contains(location2.getDataNodeId())) continue;
            dataNodeLocations.add(location2);
            dataNodeIds.add(location2.getDataNodeId());
        }
        TNodeLocations nodeLocations = new TNodeLocations();
        nodeLocations.setDataNodeLocations(dataNodeLocations);
        nodeLocations.setConfigNodeLocations(Collections.emptyList());
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodes().stream().map(TDataNodeConfiguration::getLocation).collect(Collectors.toMap(TDataNodeLocation::getDataNodeId, location -> location));
        DataNodeAsyncRequestContext dataNodeAsyncRequestContext = new DataNodeAsyncRequestContext(CnToDnAsyncRequestType.SUBMIT_TEST_DN_INTERNAL_CONNECTION_TASK, nodeLocations, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithTimeoutInMs(dataNodeAsyncRequestContext, 5000L);
        ArrayList results = new ArrayList();
        dataNodeAsyncRequestContext.getResponseMap().forEach((nodeId, resp) -> {
            if (resp.isSetResultList()) {
                results.addAll(resp.getResultList());
            }
        });
        for (TTestConnectionResult result : results) {
            int fromDataNodeId = Optional.ofNullable(result.getSender().getDataNodeLocation()).map(TDataNodeLocation::getDataNodeId).orElse(-1);
            int toDataNodeId = result.getServiceProvider().getNodeId();
            if (!result.isSuccess() || !dataNodeIds.contains(fromDataNodeId) || !dataNodeIds.contains(toDataNodeId)) continue;
            List heartbeatHistory = this.heartbeats.computeIfAbsent((Pair<Integer, Integer>)new Pair((Object)fromDataNodeId, (Object)toDataNodeId), p -> new LinkedList());
            heartbeatHistory.add(new NodeHeartbeatSample(NodeStatus.Running));
            if (heartbeatHistory.size() <= 100) continue;
            heartbeatHistory.remove(0);
        }
        Map<Integer, Set<Integer>> latestTopology = dataNodeLocations.stream().collect(Collectors.toMap(TDataNodeLocation::getDataNodeId, k -> new HashSet()));
        for (Map.Entry<Pair<Integer, Integer>, List<AbstractHeartbeatSample>> entry : this.heartbeats.entrySet()) {
            int fromId = (Integer)entry.getKey().getLeft();
            int toId = (Integer)entry.getKey().getRight();
            if (!entry.getValue().isEmpty() && !this.failureDetector.isAvailable(entry.getKey(), entry.getValue())) {
                LOGGER.debug("Connection from DataNode {} to DataNode {} is broken", (Object)fromId, (Object)toId);
                continue;
            }
            Optional.ofNullable(latestTopology.get(fromId)).ifPresent(s -> s.add(toId));
        }
        this.logAsymmetricPartition(latestTopology);
        if (this.shouldRun.get()) {
            this.topologyChangeListener.accept(latestTopology);
        }
    }

    private void logAsymmetricPartition(Map<Integer, Set<Integer>> topology) {
        Set<Integer> nodes = topology.keySet();
        if (nodes.size() == 1) {
            return;
        }
        for (int from : nodes) {
            for (int to : nodes) {
                if (from >= to) continue;
                Set<Integer> reachableFrom = topology.get(from);
                Set<Integer> reachableTo = topology.get(to);
                if (reachableFrom.size() <= 1 || reachableTo.size() <= 1 || reachableTo.contains(from) || reachableFrom.contains(to)) continue;
                LOGGER.warn("[Topology] Asymmetric network partition from {} to {}", (Object)from, (Object)to);
            }
        }
    }

    @Override
    public void onNodeStatisticsChanged(NodeStatisticsChangeEvent event) {
        Set<Integer> datanodeIds = this.configManager.getNodeManager().getRegisteredDataNodeLocations().keySet();
        Map<Integer, Pair<NodeStatistics, NodeStatistics>> changes = event.getDifferentNodeStatisticsMap();
        for (Map.Entry<Integer, Pair<NodeStatistics, NodeStatistics>> entry : changes.entrySet()) {
            Integer nodeId = entry.getKey();
            Pair<NodeStatistics, NodeStatistics> changeEvent = entry.getValue();
            if (!datanodeIds.contains(nodeId)) continue;
            if (changeEvent.getLeft() == null) {
                this.startingDataNodes.add(nodeId);
                continue;
            }
            this.startingDataNodes.remove(nodeId);
            Set<Pair> affectedPairs = this.heartbeats.keySet().stream().filter(pair -> Objects.equals(pair.getLeft(), nodeId) || Objects.equals(pair.getRight(), nodeId)).collect(Collectors.toSet());
            if (changeEvent.getRight() == null) {
                affectedPairs.forEach(this.heartbeats::remove);
                continue;
            }
            if (!NodeStatus.Unknown.equals((Object)((NodeStatistics)changeEvent.getLeft()).getStatus()) || !NodeStatus.Running.equals((Object)((NodeStatistics)changeEvent.getRight()).getStatus())) continue;
            affectedPairs.forEach(pair -> this.heartbeats.put((Pair<Integer, Integer>)pair, new ArrayList()));
            this.awaitForSignal.signal();
        }
    }
}

