/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.recover;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.iotdb.db.storageengine.dataregion.compaction.constant.CompactionTaskType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.recover.CompactionRecoverTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InsertionCrossSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.SettleCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.CompactionLogger;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.rescon.disk.TierManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionRecoverManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"COMPACTION");
    private final TsFileManager tsFileManager;
    private final String logicalStorageGroupName;
    private final String dataRegionId;

    public CompactionRecoverManager(TsFileManager tsFileManager, String logicalStorageGroupName, String dataRegionId) {
        this.tsFileManager = tsFileManager;
        this.logicalStorageGroupName = logicalStorageGroupName;
        this.dataRegionId = dataRegionId;
    }

    public void recoverCompaction() {
        ArrayList<List<String>> dataDirLists = new ArrayList<List<String>>();
        dataDirLists.add(TierManager.getInstance().getAllLocalSequenceFileFolders());
        dataDirLists.add(TierManager.getInstance().getAllLocalUnSequenceFileFolders());
        for (List list : dataDirLists) {
            for (String dir : list) {
                File storageGroupDir = new File(dir + File.separator + this.logicalStorageGroupName + File.separator + this.dataRegionId);
                logger.info("{} [Compaction][Recover] recover compaction in data region dir {}", (Object)this.logicalStorageGroupName, (Object)storageGroupDir.getAbsolutePath());
                if (!storageGroupDir.exists()) {
                    return;
                }
                File[] timePartitionDirs = storageGroupDir.listFiles();
                if (timePartitionDirs == null) {
                    return;
                }
                for (File timePartitionDir : timePartitionDirs) {
                    if (!timePartitionDir.isDirectory() || !Pattern.compile("-?\\d+").matcher(timePartitionDir.getName()).matches()) continue;
                    logger.info("{} [Compaction][Recover] recover compaction in time partition dir {}", (Object)this.logicalStorageGroupName, (Object)timePartitionDir.getAbsolutePath());
                    this.recoverCompaction(CompactionTaskType.INNER_SEQ, timePartitionDir);
                    this.recoverCompaction(CompactionTaskType.INNER_UNSEQ, timePartitionDir);
                    this.recoverCompaction(CompactionTaskType.CROSS, timePartitionDir);
                    this.recoverCompaction(CompactionTaskType.INSERTION, timePartitionDir);
                    this.recoverCompaction(CompactionTaskType.SETTLE, timePartitionDir);
                    this.recoverModSettleFile(timePartitionDir.toPath());
                }
            }
        }
    }

    public void recoverModSettleFile(Path timePartitionDir) {
        try (Stream<Path> settlesStream = Files.list(timePartitionDir);){
            settlesStream.filter(path -> path.toString().endsWith(".mods.settle")).forEach(modsSettle -> {
                Path originModFile = modsSettle.resolveSibling(modsSettle.getFileName().toString().replace(".settle", ""));
                try {
                    if (Files.exists(originModFile, new LinkOption[0])) {
                        Files.deleteIfExists(modsSettle);
                    } else {
                        Files.move(modsSettle, originModFile, new CopyOption[0]);
                    }
                }
                catch (IOException e) {
                    logger.error("recover mods file error on delete origin file or rename mods settle,", (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            logger.error("recover mods file error on list files:{}", (Object)timePartitionDir, (Object)e);
        }
    }

    private void recoverCompaction(CompactionTaskType type, File timePartitionDir) {
        File[] compactionLogs;
        block6: for (File compactionLog : compactionLogs = CompactionLogger.findCompactionLogs(type, timePartitionDir)) {
            switch (type) {
                case INNER_SEQ: 
                case INNER_UNSEQ: 
                case REPAIR: {
                    new CompactionRecoverTask(this.logicalStorageGroupName, this.dataRegionId, this.tsFileManager, compactionLog, true).doCompaction();
                    continue block6;
                }
                case CROSS: {
                    new CompactionRecoverTask(this.logicalStorageGroupName, this.dataRegionId, this.tsFileManager, compactionLog, false).doCompaction();
                    continue block6;
                }
                case INSERTION: {
                    new InsertionCrossSpaceCompactionTask(this.logicalStorageGroupName, this.dataRegionId, this.tsFileManager, compactionLog).recover();
                    continue block6;
                }
                case SETTLE: {
                    new SettleCompactionTask(this.logicalStorageGroupName, this.dataRegionId, this.tsFileManager, compactionLog).recover();
                    continue block6;
                }
                default: {
                    logger.warn("Unknown compaction task type {}", (Object)type);
                    return;
                }
            }
        }
    }
}

