/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.filter.basic;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.tsfile.file.metadata.IMetadata;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.filter.basic.OperatorType;
import org.apache.tsfile.read.filter.operator.And;
import org.apache.tsfile.read.filter.operator.GroupByFilter;
import org.apache.tsfile.read.filter.operator.GroupByMonthFilter;
import org.apache.tsfile.read.filter.operator.Not;
import org.apache.tsfile.read.filter.operator.Or;
import org.apache.tsfile.read.filter.operator.TimeFilterOperators;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.FilterDeserialize;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public abstract class Filter {
    public abstract boolean satisfy(long var1, Object var3);

    public abstract boolean satisfyBoolean(long var1, boolean var3);

    public abstract boolean satisfyInteger(long var1, int var3);

    public abstract boolean satisfyLong(long var1, long var3);

    public abstract boolean satisfyFloat(long var1, float var3);

    public abstract boolean satisfyDouble(long var1, double var3);

    public abstract boolean satisfyBinary(long var1, Binary var3);

    public abstract boolean satisfyRow(long var1, Object[] var3);

    public abstract boolean satisfyBooleanRow(long var1, boolean[] var3);

    public abstract boolean satisfyIntegerRow(long var1, int[] var3);

    public abstract boolean satisfyLongRow(long var1, long[] var3);

    public abstract boolean satisfyFloatRow(long var1, float[] var3);

    public abstract boolean satisfyDoubleRow(long var1, double[] var3);

    public abstract boolean satisfyBinaryRow(long var1, Binary[] var3);

    @Deprecated
    public abstract boolean[] satisfyTsBlock(TsBlock var1);

    public abstract boolean[] satisfyTsBlock(boolean[] var1, TsBlock var2);

    public abstract boolean canSkip(IMetadata var1);

    public abstract boolean allSatisfy(IMetadata var1);

    public abstract boolean satisfyStartEndTime(long var1, long var3);

    public abstract boolean containStartEndTime(long var1, long var3);

    public abstract List<TimeRange> getTimeRanges();

    public abstract Filter reverse();

    public Filter copy() {
        return this;
    }

    public abstract OperatorType getOperatorType();

    public void serialize(DataOutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write(this.getOperatorType().ordinal(), (OutputStream)outputStream);
    }

    public void serialize(ByteBuffer buffer) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.serialize(dataOutputStream);
        buffer.put(byteArrayOutputStream.toByteArray());
    }

    public static Filter deserialize(ByteBuffer buffer) {
        OperatorType type = OperatorType.values()[ReadWriteIOUtils.readInt(buffer)];
        switch (type) {
            case TIME_EQ: {
                return new TimeFilterOperators.TimeEq(buffer);
            }
            case TIME_NEQ: {
                return new TimeFilterOperators.TimeNotEq(buffer);
            }
            case TIME_GT: {
                return new TimeFilterOperators.TimeGt(buffer);
            }
            case TIME_GTEQ: {
                return new TimeFilterOperators.TimeGtEq(buffer);
            }
            case TIME_LT: {
                return new TimeFilterOperators.TimeLt(buffer);
            }
            case TIME_LTEQ: {
                return new TimeFilterOperators.TimeLtEq(buffer);
            }
            case TIME_IN: {
                return new TimeFilterOperators.TimeIn(buffer);
            }
            case TIME_NOT_IN: {
                return new TimeFilterOperators.TimeNotIn(buffer);
            }
            case TIME_BETWEEN_AND: {
                return new TimeFilterOperators.TimeBetweenAnd(buffer);
            }
            case TIME_NOT_BETWEEN_AND: {
                return new TimeFilterOperators.TimeNotBetweenAnd(buffer);
            }
            case VALUE_EQ: 
            case VALUE_NEQ: 
            case VALUE_GT: 
            case VALUE_GTEQ: 
            case VALUE_LT: 
            case VALUE_LTEQ: 
            case VALUE_IS_NULL: 
            case VALUE_IS_NOT_NULL: 
            case VALUE_IN: 
            case VALUE_NOT_IN: 
            case VALUE_REGEXP: 
            case VALUE_NOT_REGEXP: 
            case VALUE_BETWEEN_AND: 
            case VALUE_NOT_BETWEEN_AND: {
                return FilterDeserialize.deserializeValueFilter(type, buffer);
            }
            case GROUP_BY_TIME: {
                return new GroupByFilter(buffer);
            }
            case GROUP_BY_MONTH: {
                return new GroupByMonthFilter(buffer);
            }
            case AND: {
                return new And(buffer);
            }
            case OR: {
                return new Or(buffer);
            }
            case NOT: {
                return new Not(buffer);
            }
        }
        throw new UnsupportedOperationException("Unsupported operator type:" + (Object)((Object)type));
    }
}

