/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantilescommon;

import java.util.Objects;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;

public final class QuantilesUtil {
    public static final double tailRoundingFactor = 1.0E7;

    private QuantilesUtil() {
    }

    public static final void checkNormalizedRankBounds(double nRank) {
        if (nRank < 0.0 || nRank > 1.0) {
            throw new SketchesArgumentException("A normalized rank must be >= 0 and <= 1.0: " + nRank);
        }
    }

    public static final void checkDoublesSplitPointsOrder(double[] values) {
        Objects.requireNonNull(values);
        int len = values.length;
        if (len == 1 && Double.isNaN(values[0])) {
            throw new SketchesArgumentException("Values must be unique, monotonically increasing and not NaN.");
        }
        for (int j = 0; j < len - 1; ++j) {
            if (values[j] < values[j + 1]) continue;
            throw new SketchesArgumentException("Values must be unique, monotonically increasing and not NaN.");
        }
    }

    public static void checkLongsSplitPointsOrder(long[] values) {
        Objects.requireNonNull(values);
        int len = values.length;
        for (int j = 0; j < len - 1; ++j) {
            if (values[j] < values[j + 1]) continue;
            throw new SketchesArgumentException("Values must be unique and monotonically increasing.");
        }
    }

    public static final void checkFloatsSplitPointsOrder(float[] values) {
        Objects.requireNonNull(values);
        int len = values.length;
        if (len == 1 && Float.isNaN(values[0])) {
            throw new SketchesArgumentException("Values must be unique, monotonically increasing and not NaN.");
        }
        for (int j = 0; j < len - 1; ++j) {
            if (values[j] < values[j + 1]) continue;
            throw new SketchesArgumentException("Values must be unique, monotonically increasing and not NaN.");
        }
    }

    public static double[] equallySpacedDoubles(int num) {
        if (num < 1) {
            throw new IllegalArgumentException("num must be >= 1");
        }
        double[] out = new double[num + 1];
        out[0] = 0.0;
        out[num] = 1.0;
        double delta = 1.0 / (double)num;
        for (int i = 1; i < num; ++i) {
            out[i] = (double)i * delta;
        }
        return out;
    }

    public static long[] equallySpacedLongs(long min, long max, int num) {
        if (num < 1 || min < 0L || max < 1L || min >= max || (long)num > max - min) {
            throw new SketchesArgumentException("Improper inputs: n < 1, min < 0, max < 1, min >= max, or n > (max - min)");
        }
        long span = max - min;
        double[] splits = QuantilesUtil.equallySpacedDoubles(num);
        int len = num + 1;
        long[] out = new long[len];
        long prev = -1L;
        for (int i = 0; i < len; ++i) {
            long cur = Math.round(splits[i] * (double)span);
            if (cur == prev) {
                ++cur;
            } else {
                prev = cur;
            }
            out[i] = min + cur;
        }
        return out;
    }

    public static float[] evenlySpacedFloats(float value1, float value2, int num) {
        if (num < 2) {
            throw new SketchesArgumentException("num must be >= 2");
        }
        float[] out = new float[num];
        out[0] = value1;
        out[num - 1] = value2;
        if (num == 2) {
            return out;
        }
        float delta = (value2 - value1) / (float)(num - 1);
        for (int i = 1; i < num - 1; ++i) {
            out[i] = (float)i * delta + value1;
        }
        return out;
    }

    public static double[] evenlySpacedDoubles(double value1, double value2, int num) {
        if (num < 2) {
            throw new SketchesArgumentException("num must be >= 2");
        }
        double[] out = new double[num];
        out[0] = value1;
        out[num - 1] = value2;
        if (num == 2) {
            return out;
        }
        double delta = (value2 - value1) / (double)(num - 1);
        for (int i = 1; i < num - 1; ++i) {
            out[i] = (double)i * delta + value1;
        }
        return out;
    }

    public static double[] evenlyLogSpaced(double value1, double value2, int num) {
        if (num < 2) {
            throw new SketchesArgumentException("num must be >= 2");
        }
        if (value1 <= 0.0 || value2 <= 0.0) {
            throw new SketchesArgumentException("value1 and value2 must be > 0.");
        }
        double[] arr = QuantilesUtil.evenlySpacedDoubles(Math.log(value1) / Util.LOG2, Math.log(value2) / Util.LOG2, num);
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = Math.pow(2.0, arr[i]);
        }
        return arr;
    }

    public static double getNaturalRank(double normalizedRank, long totalN, QuantileSearchCriteria searchCrit) {
        double naturalRank = normalizedRank * (double)totalN;
        if ((double)totalN <= 1.0E7) {
            naturalRank = (double)Math.round(naturalRank * 1.0E7) / 1.0E7;
        }
        return searchCrit == QuantileSearchCriteria.INCLUSIVE ? (double)((long)Math.ceil(naturalRank)) : (double)((long)Math.floor(naturalRank));
    }
}

