/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.common.builder;

import java.util.Vector;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.intf.AxiomElement;
import org.apache.axiom.om.impl.intf.factory.AxiomElementType;
import org.apache.axiom.om.impl.intf.factory.AxiomNodeFactory;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.impl.common.builder.SOAPBuilderHelper;

public class SOAP12BuilderHelper
extends SOAPBuilderHelper {
    private boolean codePresent = false;
    private boolean reasonPresent = false;
    private boolean nodePresent = false;
    private boolean rolePresent = false;
    private boolean detailPresent = false;
    private boolean subcodeValuePresent = false;
    private boolean subSubcodePresent = false;
    private boolean valuePresent = false;
    private boolean subcodePresent = false;
    private boolean codeprocessing = false;
    private boolean subCodeProcessing = false;
    private boolean reasonProcessing = false;
    private boolean processingDetailElements = false;
    private Vector<String> detailElementNames;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public AxiomElementType<? extends AxiomElement> handleEvent(OMElement parent, int elementLevel, String namespaceURI, String localName) throws SOAPProcessingException {
        AxiomElementType<AxiomElement> elementType = null;
        if (elementLevel == 4) {
            if (localName.equals("Code")) {
                if (this.codePresent) {
                    throw new SOAPProcessingException("Multiple Code element encountered");
                }
                elementType = AxiomNodeFactory::createSOAP12FaultCode;
                this.codePresent = true;
                this.codeprocessing = true;
                return elementType;
            }
            if (localName.equals("Reason")) {
                if (!this.codeprocessing && !this.subCodeProcessing) {
                    if (!this.codePresent) throw new SOAPProcessingException("Wrong element order encountred at " + localName);
                    if (this.reasonPresent) {
                        throw new SOAPProcessingException("Multiple Reason Element encountered");
                    }
                    elementType = AxiomNodeFactory::createSOAP12FaultReason;
                    this.reasonPresent = true;
                    this.reasonProcessing = true;
                    return elementType;
                }
                if (!this.codeprocessing) throw new SOAPProcessingException("A subcode doesn't have a Value");
                throw new SOAPProcessingException("Code doesn't have a value");
            }
            if (localName.equals("Node")) {
                if (this.reasonProcessing) throw new SOAPProcessingException("Reason element Should have a text");
                if (!this.reasonPresent) throw new SOAPProcessingException("wrong element order encountered at " + localName);
                if (this.rolePresent) throw new SOAPProcessingException("wrong element order encountered at " + localName);
                if (this.detailPresent) throw new SOAPProcessingException("wrong element order encountered at " + localName);
                if (this.nodePresent) {
                    throw new SOAPProcessingException("Multiple Node element encountered");
                }
                elementType = AxiomNodeFactory::createSOAP12FaultNode;
                this.nodePresent = true;
                return elementType;
            }
            if (localName.equals("Role")) {
                if (this.reasonProcessing) throw new SOAPProcessingException("Reason element should have a text");
                if (!this.reasonPresent) throw new SOAPProcessingException("Wrong element order encountered at " + localName);
                if (this.detailPresent) throw new SOAPProcessingException("Wrong element order encountered at " + localName);
                if (this.rolePresent) {
                    throw new SOAPProcessingException("Multiple Role element encountered");
                }
                elementType = AxiomNodeFactory::createSOAP12FaultRole;
                this.rolePresent = true;
                return elementType;
            }
            if (!localName.equals("Detail")) throw new SOAPProcessingException(localName + " unsupported element in SOAPFault element");
            if (this.reasonProcessing) throw new SOAPProcessingException("Reason element should have a text");
            if (!this.reasonPresent) throw new SOAPProcessingException("wrong element order encountered at " + localName);
            if (this.detailPresent) {
                throw new SOAPProcessingException("Multiple detail element encountered");
            }
            elementType = AxiomNodeFactory::createSOAP12FaultDetail;
            this.detailPresent = true;
            return elementType;
        }
        if (elementLevel == 5) {
            if (parent.getLocalName().equals("Code")) {
                if (localName.equals("Value")) {
                    if (this.valuePresent) throw new SOAPProcessingException("Multiple value Encountered in code element");
                    elementType = AxiomNodeFactory::createSOAP12FaultValue;
                    this.valuePresent = true;
                    this.codeprocessing = false;
                    return elementType;
                }
                if (!localName.equals("Subcode")) throw new SOAPProcessingException(localName + " is not supported inside the code element");
                if (this.subcodePresent) throw new SOAPProcessingException("multiple subcode Encountered in code element");
                if (!this.valuePresent) throw new SOAPProcessingException("Value should present before the subcode");
                elementType = AxiomNodeFactory::createSOAP12FaultSubCode;
                this.subcodePresent = true;
                this.subCodeProcessing = true;
                return elementType;
            }
            if (parent.getLocalName().equals("Reason")) {
                if (!localName.equals("Text")) throw new SOAPProcessingException(localName + " is not supported inside the reason");
                elementType = AxiomNodeFactory::createSOAP12FaultText;
                this.reasonProcessing = false;
                return elementType;
            }
            if (!parent.getLocalName().equals("Detail")) throw new SOAPProcessingException(parent.getLocalName() + " should not have child element");
            elementType = AxiomNodeFactory::createNSAwareElement;
            this.processingDetailElements = true;
            this.detailElementNames = new Vector();
            this.detailElementNames.add(localName);
            return elementType;
        }
        if (elementLevel <= 5) return elementType;
        if (parent.getLocalName().equals("Subcode")) {
            if (!localName.equals("Value")) {
                if (!localName.equals("Subcode")) throw new SOAPProcessingException(localName + " is not supported inside the subCode element");
                if (!this.subcodeValuePresent) throw new SOAPProcessingException("Value should present before the subcode");
                if (this.subSubcodePresent) throw new SOAPProcessingException("multiple subcode encountered");
                elementType = AxiomNodeFactory::createSOAP12FaultSubCode;
                this.subcodeValuePresent = false;
                this.subSubcodePresent = true;
                this.subCodeProcessing = true;
                return elementType;
            }
            if (this.subcodeValuePresent) {
                throw new SOAPProcessingException("multiple subCode value encountered");
            }
            elementType = AxiomNodeFactory::createSOAP12FaultValue;
            this.subcodeValuePresent = true;
            this.subSubcodePresent = false;
            this.subCodeProcessing = false;
            return elementType;
        }
        if (!this.processingDetailElements) throw new SOAPProcessingException(parent.getLocalName() + " should not have child at element level " + elementLevel);
        int detailElementLevel = 0;
        boolean localNameExist = false;
        int i = 0;
        while (true) {
            if (i >= this.detailElementNames.size()) {
                if (!localNameExist) return elementType;
                this.detailElementNames.setSize(detailElementLevel);
                elementType = AxiomNodeFactory::createNSAwareElement;
                this.detailElementNames.add(localName);
                return elementType;
            }
            if (parent.getLocalName().equals(this.detailElementNames.get(i))) {
                localNameExist = true;
                detailElementLevel = i + 1;
            }
            ++i;
        }
    }
}

