/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server.endpoint;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.Binding;
import javax.xml.ws.Endpoint;
import javax.xml.ws.EndpointContext;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.addressing.util.EndpointReferenceUtils;
import org.apache.axis2.jaxws.binding.BindingUtils;
import org.apache.axis2.jaxws.description.DescriptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.transport.http.HTTPWorkerFactory;
import org.apache.axis2.transport.http.server.SimpleHttpServer;
import org.apache.axis2.transport.http.server.WorkerFactory;
import org.w3c.dom.Element;

public class EndpointImpl
extends Endpoint {
    private boolean published;
    private Object implementor;
    private EndpointDescription endpointDesc;
    private Binding binding;
    private SimpleHttpServer server;
    private List<Source> metadata;
    private Map<String, Object> properties;
    private Executor executor;
    private EndpointContext endpointCntx;

    public EndpointImpl(Object o) {
        this.implementor = o;
        this.initialize();
    }

    public EndpointImpl(Object o, Binding bnd, EndpointDescription ed) {
        this.implementor = o;
        this.endpointDesc = ed;
        this.initialize();
    }

    private void initialize() {
        if (this.implementor == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"initErr"));
        }
        if (this.endpointDesc == null) {
            ServiceDescription sd = DescriptionFactory.createServiceDescription(this.implementor.getClass());
            this.endpointDesc = (EndpointDescription)sd.getEndpointDescriptions_AsCollection().iterator().next();
        }
        if (this.endpointDesc != null && this.binding == null) {
            this.binding = BindingUtils.createBinding(this.endpointDesc);
        }
        this.published = false;
    }

    public List<Source> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(List<Source> list) {
        this.metadata = list;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public Object getImplementor() {
        return this.implementor;
    }

    public void setEndpointContext(EndpointContext ctxt) {
        this.endpointCntx = ctxt;
    }

    public boolean isPublished() {
        return this.published;
    }

    public void publish(Object obj) {
        if (this.isPublishDisabled()) {
            throw new UnsupportedOperationException("Endpoint publish not allowed in managed environment");
        }
    }

    private boolean isPublishDisabled() {
        boolean publishDisabled = false;
        if (this.endpointDesc != null) {
            ConfigurationContext cfgCtx = this.endpointDesc.getServiceDescription().getAxisConfigContext();
            AxisConfiguration axisConfig = cfgCtx.getAxisConfiguration();
            Parameter parameter = axisConfig.getParameter("jaxws.endpoint.publish.disable");
            String flagValue = null;
            if (parameter != null) {
                flagValue = (String)parameter.getValue();
            }
            if (flagValue != null) {
                if ("false".equalsIgnoreCase(flagValue)) {
                    publishDisabled = false;
                } else if ("true".equalsIgnoreCase(flagValue)) {
                    publishDisabled = true;
                }
            }
        }
        return publishDisabled;
    }

    public void publish(String s) {
        if (this.isPublishDisabled()) {
            throw new UnsupportedOperationException("Endpoint publish not allowed in managed environment");
        }
        int port = -1;
        String address = s;
        try {
            URI uri = new URI(s);
            port = uri.getPort();
        }
        catch (URISyntaxException uri) {
            // empty catch block
        }
        if (port == -1) {
            port = 8080;
            address = s + ":" + port;
        }
        ConfigurationContext ctx = this.endpointDesc.getServiceDescription().getAxisConfigContext();
        if (this.endpointDesc.getEndpointAddress() == null) {
            this.endpointDesc.setEndpointAddress(address);
        }
        try {
            AxisService svc = this.endpointDesc.getAxisService();
            ctx.getAxisConfiguration().addService(svc);
        }
        catch (AxisFault e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
        ctx.setContextRoot("/");
        HTTPWorkerFactory wf = new HTTPWorkerFactory();
        try {
            this.server = new SimpleHttpServer(ctx, (WorkerFactory)wf, port);
            this.server.init();
            this.server.start();
        }
        catch (IOException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
        this.published = true;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void stop() {
        try {
            if (this.server != null) {
                this.server.destroy();
            }
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, Element ... referenceParameters) {
        Source wsdlSource;
        if (!this.isPublished()) {
            throw new WebServiceException("Endpoint is not published");
        }
        if (!BindingUtils.isSOAPBinding(this.binding.getBindingID())) {
            throw new UnsupportedOperationException("This method is unsupported for the binding: " + this.binding.getBindingID());
        }
        EndpointReference jaxwsEPR = null;
        String addressingNamespace = EndpointReferenceUtils.getAddressingNamespace(clazz);
        String address = this.endpointDesc.getEndpointAddress();
        QName serviceName = this.endpointDesc.getServiceQName();
        QName portName = this.endpointDesc.getPortQName();
        String wsdlLocation = null;
        if (this.metadata != null && (wsdlSource = this.metadata.get(0)) != null) {
            wsdlLocation = wsdlSource.getSystemId();
        }
        org.apache.axis2.addressing.EndpointReference axis2EPR = EndpointReferenceUtils.createAxis2EndpointReference(address, serviceName, portName, wsdlLocation, addressingNamespace);
        try {
            EndpointReferenceUtils.addReferenceParameters(axis2EPR, referenceParameters);
            jaxwsEPR = EndpointReferenceUtils.convertFromAxis2(axis2EPR, addressingNamespace);
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"endpointRefCreationError"), (Throwable)e);
        }
        return (T)((EndpointReference)clazz.cast(jaxwsEPR));
    }

    public EndpointReference getEndpointReference(Element ... referenceParameters) {
        return this.getEndpointReference(W3CEndpointReference.class, referenceParameters);
    }
}

